# 第九章 开源贡献
 
时至今日，在全球开源界普遍认同中国企业和中国开发者对全球开源产业贡献巨大的背景下，依然有许多国内人士认为中国是全球开源资源的索取者和使用者，这是成见，更是偏见。

事实上，在上世纪90年代中期，中国尚处在开源的启蒙阶段，国内最早接触的技术先驱者就尝试积极参与国际开源社区的代码共享活动。虽是凤毛麟角，但星星之火终成燎原之势。

21世纪初，随着国内Linux系统和LAMP技术栈的兴起，中国开源进入了萌芽阶段，一些全球知名企业的在华研究机构成建制的组织中国开发者系统地参与到国际知名开源社区中。自此，国内开源社区如雨后春笋般层出不穷，开源文化在当时这批20岁出头的中国开发者心中埋下了种子。
	
时间来到2008年，这一年是中国开源发展史上的重要里程碑，Linux基金会、Gnome基金会、Apache软件基金会，以及OpenOffice基金会不约而同地选择在北京举办相关技术峰会，实现了他们在亚洲的首秀。因此，2008年成为重要转折点，全球开源界已承认中国的开源贡献者的地位，中国开源的第三个发展阶段随之到来。
	
在过去13年中，中国开源开发者已经开始习惯用流利的英语和全球开源人士分享他们的技术经验。根据中国开源软件推进联盟统计，2016年至2017年在华召开的开源国际会议上发表的论文中，来自国内和国外的的论文比例为4 ：6，即有40%的开源论文来自中国开发者。中国的开源力量正在以惊人的速度迎头赶上，在开源开发者贡献度、开源社区活跃度、开源基金会参与度等方面，均取得不俗成绩。这些来自中国的开发者和科技企业正在向全世界呈现全新的中国开源形象，逐步实现了开源世界的大国担当。
	
本章引用全球知名开源基金会和业内最具代表性的开源社区的详实数据，来呈现开源世界中的中国贡献，以及外企对中国开源发展所带来的推动作用。


## 9.1 国际开源社区的中国贡献

### 9.1.1  中国开发者已经成为Kernel.org社区最大贡献群体

在开源世界中，Kernel.org社区的象征意义无可替代，开源界的创世一代至今依然活跃在这个社区，于是Kernel.org社区至今仍常被作为一个开源指数来度量一个企业或一个区域的开源繁荣和发展程度。为了更加全面的呈现中国在开源领域的成长过程，我们分别通过中国开发者和中国科技企业对Kernel.org社区的补丁贡献数据来呈现。
 
下表是2005年6月以来，中国开发者对Kernel.org社区的贡献数据和贡献度排名变化。

![在这里插入图片描述](https://img-blog.csdnimg.cn/0956a569098246718b1cf01e6b965375.png#pic_center)<br/>
*2005年6月以来，中国开发者对Kernel.org社区的贡献数据和贡献度排名变化*

从下表中可看出，在过去的16年间，参与Kernel.org社区的中国开发者的规模提升到34倍，对社区的贡献绝对数量提升到3476%，对Kernel.org的贡献排名近五年来保持世界第一。

|内核版本|中国贡献补丁数量|中国贡献补丁占比|中国开发者数量|国家贡献排名|
|-----|-----|-----|-----|-----|
|V2.6.12|50|2.9%|12|第七名|
|V2.6.24|395|4.02%|57|第六名|
|V3.0|540|5.9%|96|第五名|
|V4.0|771|7.45%|160|第三名|
|V5.0|1444|11.27%|289|第一名|
|V5.17|1738|14.35%|403|第一名|


通过对比12年来中国开发者数量的变化，可以推算出中国开发者对Kernel.org社区的人均贡献度，其整体变化如下表所示。

![在这里插入图片描述](https://img-blog.csdnimg.cn/793c384a17a64005a7c55882b52b8192.png#pic_center)<br/>


通过对比最进三个内核版本排名前三国家的开发者人数和人均贡献值，可以发现，现今中国开发者的人均贡献度远小于德国和美国，未来中国开发者的人均贡献度和绝对贡献数量还有很大提升空间。

![在这里插入图片描述](https://img-blog.csdnimg.cn/d36461756a154458986f005b26ea18cf.png#pic_center)<br/>


纵观Kernel.org社区总体开发者贡献，会发现中国、美国、德国、英国、法国和印度是该社区的主要贡献群体，其中中国的发展速度远远超过上述国家，详见下表。

![在这里插入图片描述](https://img-blog.csdnimg.cn/0a512241d37c4927a9f9530153f6ffca.png#pic_center)<br/>


从另一个角度，我们同样可以发现中国企业在Kernel.org社区中的贡献度越来越大，相关排名持续上升，下表我们是最近五年从Kernel4.10至今的中国企业内核社区贡献排名。

![在这里插入图片描述](https://img-blog.csdnimg.cn/fa054edbd4ad4895a1352565edce2edd.png#pic_center)<br/>


此外，联想、酷派、麒麟软件和小米均对内核社区有贡献。


### 9.1.2  中国开发者成为RISC-V生态中不可或缺的组成部分

![在这里插入图片描述](https://img-blog.csdnimg.cn/fa054edbd4ad4895a1352565edce2edd.png#pic_center)<br/>


2011年5月，加州大学伯克利分校研究团队发布了一套全新的开放指令集，RISC-V诞生了。2015年汇聚了全球100多家单位的非营利组织RISC-V基金会正式成立。为了降低潜在的技术出口法律限制风险，减轻来自地缘政治的潜在破坏，同时为了确保基金会更加中立、开放和包容，RISC-V基金会将注册地迁移至瑞士，此举受到全球RISC-V爱好者的广泛好评。RISC-V基金会的日常运营由董事会负责，董事会由四名常委和十六名委员构成，其中的中方委员有九名，占比达到45%。

![在这里插入图片描述](https://img-blog.csdnimg.cn/a8f9fd9656814664b38f062f75d6596c.png#pic_center)<br/>


在RISC-V这一轮发展浪潮中，中国企业、高效和科研机构发挥了巨大作用。有数据显示，中国有超过400家企业关注、参与和使用RISC-V指令集进行开发。据统计，在RISC-V基金会中，成员分为三个层次，在基金会核心成员（Premier Member）中，中方成员占比达到57.9%，在战略成员（Strategic Member）中，中方成员占比达到26.8%，在社区组织成员（Community Organization Member）中，中方成员占比达到7.6%。

![在这里插入图片描述](https://img-blog.csdnimg.cn/0632caff1e2e42d6814bb6702e7575a3.png#pic_center)<br/>


特别是2018年以来，RISC-V在中国的发展呈现加速之势，以下为相关标志性事件。

2018年2月，《RISC-V手册》中文版出版；

2018年5月，胡振波撰写的《手把手教你设计CPU——RISC-V处理器》正式出版；

2018年7月，上海经信委出台了国内首个支持RISC-V的政策；

2018年9月，中国RISC-V产业联盟在上海成立；

2018年9月，华米科技发布基于RISC-V的可穿戴处理器“黄山1号”；

2018年11月，中国开放指令生态（RISC-V）联盟在乌镇成立；

2019年1月，《开放指令集与开源芯片发展报告》发布；

2019年7月，阿里平头哥正式发布RISC-V处理器玄铁910；

2019年9月，中国开放指令生态联盟联合BenchCouncil举办RISC-V国际智能系统大赛；

2019年10月，阿里平头哥宣布开源RISC-V的MCU平台无剑100Open；

2019年10月，卡姆派乐发布RISC-V集成开发环境-卡姆派乐IDE；

2019年11月，清华-伯克利深圳学院设立RIOS实验室，图灵奖得主大卫帕特森领衔；

2020年1月，上海交通大学与上海瓶钵开源了基于RISC-V 架构的TEE安全系统“蓬莱”；

2020年3月，兆易创新GD32MCU获Embedded Award 2020国际顶级大奖；

2020年4月，芯来科技发布“Nuclei RISC-V大学计划”；

2020年6月，“香山”开源高性能处理器项目启动；

2020年6月，华米科技发布基于RISC-V的“黄山2号”可穿戴AI芯片；

2020年7月，中国科学院大学发布针对RISC-V处理器的“一生一芯”计划；

2020年8月，卡姆派乐公司开源RISC-V向量LLVM编译器；

2020年8月，RIOS发布全球首个运行Linux的RISC-V开源边缘计算平台PicoRio；

2020年9月，RIOS的曹野移植Chromium OS到RISC-V；

2020年9月，赛昉科技发布基于RISC-V人工视觉处理平台——惊鸿7100；

2020年11月，RT-Thread发布RISC-V的国产集成开发环境RT-Thread Studio；

2020年11月，千芯科技发布针对芯来RISC-V平台的AI部署工具包（tinyAI SDK）

2020年12月，芯来科技推出开源RISC-V处理器教学平台——蜂鸟E203 SoC；

2021年1月，阿里平头哥为RISC-V移植安卓10系统并开源；

2021年2月，平头哥携手阿里云天池举办“RISC-V应用创新大赛”；

2021年3月，中科蓝讯RISC-V指令集蓝牙芯片累计超过10亿颗；

2021年4月，芯来科技为RISC-V移植了鸿蒙LiteOS-M内核；

2021年5月，华为海思推出基于RISC-V的Hi3861的开发板；

2021年6月，阿里平头哥推出三款RISC-V开发板分别支持Android、Linux、AliOS Things；

2021年7月，“香山”第一版处理器“雁栖湖”（28nm）正式流片；

2021年8月，赛昉科技累计融资10亿元；

2021年9月，睿思芯科完成A轮数千万美金投资；

2021年10月，阿里平头哥开源四款RISC-V处理器E902、E906、C906和C910；

2021年12月，赛昉科技发布RISC-V CPU Core IP“昉·天枢”和昉·星光RISC-V单板计算机；

2021年12月，阿里平头哥宣布RISC-V玄铁处理器累计出货超过25亿颗；

2021年12月，华为海思基于RISC-V发布Hi373V110电视芯片及LiteOS；

在上述标志性事件中，我们可以看出在2018年12月RISC-V基金会首次宣布要迁至瑞士后，中国企业界和学术界加速了参与和融入RISC-V基金会的进程，其中中国RISC-V产业联盟和中国开放指令生态（RISC-V）联盟发挥了巨大的促进作用。自2020年开始，中国国内的RISC-V生态快速完善，并开始涌现越来越多的RISC-V产业化案例。

众所周知，中国一直在芯片领域处于受制于人的窘境，整个产业迫切走出一条自力更生、自主创新之路。RISC-V由于开源的特性，自诞生起就在产业界备受瞩目，大量中国芯片公司正在成为RISC-V的拥趸，加大对RISC-V的投入。而中国具备的电子制造业生态优势，也成为RISC-V应用前景最乐观的领域。RISC-V在中国的市场容量和发展潜力巨大，这些因素成就了双方“互利互助、合作共赢”的合作。

另一方面，RISC-V生态中的相应软件、工具链还有待完善。RISC-V指令集开源并不意味着CPU核心也同时免费授权，这对芯片公司提出了很高的设计和研发要求。客观上说，目前RISC-V只是帮中国芯片产业走上快车道，但前路漫漫，还需要我们持续努力。未来RISC-V生态建设中，中国企业需要平心静气、戒骄戒躁，避免在资本的推动下过度炒作概念，同时加强全球产业合作，避免产业生态的碎片化趋势。

### 9.1.3 中国用户和开发者已成为OpenCV社区中坚力量

最近十年，中国成为开源计算机视觉软件OpenCV最大用户。根据Sourceforge.net的统计，2012年中国下载量排在美国日本之后，2013年开始中国超越美国和日本位居第一。中国下载量占全球比例持续增加，至2021年已达41.4%，即全球下载量有超过四成来自中国。也就是随着人工智能领域在中国的发展，中国已经成为OpenCV第一大用户，远超其他国家。

![在这里插入图片描述](https://img-blog.csdnimg.cn/9b18ff4178b64bde9e57cb3d65790866.png#pic_center)<br/>


OpenCV最初由Intel公司在俄罗斯的研发团队开发，于2000年正式对外发布。现在OpenCV已经由OpenCV基金会社区化运作，有来自全世界各地的开发者为之贡献代码。由于历史原因，很多关键的功能都是由来自俄罗斯的开发者提供。这些开发者或来自俄罗斯的Intel、Xperience.ai等公司。

与此同时，在OpenCV社区中的中国开发者贡献比例也在逐年攀升。以“Google Summer of Code”为例，2017年至2021年Google共资助OpenCV 48个项目，其中14个由中国开发者承担，中国开发者占比29.2%。在此之前的2011年至2016年，中国开发者仅占8.4%（6/71）。OpenCV的Area Chair，是一个招募高级科学家为OpenCV做算法贡献的社区项目，据2022年OpenCV春季公布的首批OpenCV Area Chair，共有9人，其中4名是中国科学家，占比44.4%。南方科技大学的于仕琪教授是Github上OpenCV项目的管理员之一，具有代码管理权限。

![在这里插入图片描述](https://img-blog.csdnimg.cn/2efdd44dec6f4412bde6ad108b8929b6.png#pic_center)<br/>


2019年，OpenCV中国团队成立，得到深圳市人工智能与机器人研究院和南方科技大学的支持。OpenCV近两年在中国的发展，得益于OpenCV中国团队的助力，该团队致力于引导中国开发力量为OpenCV做贡献，使中国科研成果普惠全世界。同时改进OpenCV，使之适应未来的应用，特别是机器人相关应用，促进科研成果快速落地。

OpenCV开发团队在负责人Vadim Pisarevsky的带领下，一方面进行核心模块的设计和开发，另一方面进行推广和培训。与此同时，Vadim Pisarevsky和于仕琪教授皆是OpenCV基金会董事成员，积极推动了基金会的社区化改革，提议了OpenCV Development Partnership，OpenCV Membershiop和OpenCV Area Chair三个方案，这三个方案皆被OpenCV基金会接受并实施。

2020年，OpenCV启动OpenCV Development Partnership计划，招募有意为OpenCV做贡献且在OpenCV生态链的公司加入，陆续开放智能机器（上海）有限公司、奥比中光科技集团股份有限公司、深圳市世野科技有限公司等多家中国公司加入。

OpenCV基金会于2021年正式对外开放OpenCV Membership，招募企业会员。2021年底，华为正式加入OpenCV基金会，成为OpenCV会员。最近两年，中科院软件所、阿里平头哥公司为OpenCV贡献了非常核心的RISC-V CPU支持；腾讯公司为OpenCV贡献了QR二维码扫码算法；北京邮电大学、华中科技大学、南方科技大学等高校为OpenCV贡献了大量关键视觉算法。

## 9.2 中国企业在开源基金会中发挥重要作用

### 9.2.1 中国成员在Apache软件基金会（ASF）的参与度

截至2021年，Apache软件基金会源自中国的活跃开源项目共24个，其中有14个项目成为了顶级项目。分别是：

* Apache DolphinScheduler（2019/8/29-2021/04/08）
* Apache ECharts (2018/1/18 - 2020/12/16）
* Apache Ozone (2018/11-22 - 2020/10/21)
* Apache IoTDB（2018/11/18 - 2020/9/17）
* Apache APISIX（2019/10/17 - 2020/07/15）
* Apache ShardingSphere（2018/11/10 – 2020/4/16）
* Apache Dubbo（2018/2/16 – 2019/5/15）
* Apache Skywalking（2017/12/8 – 2019/4/17）
* Apache Griffin（2016/12/5 – 2018/11/21）
* Apache ServiceComb（2017/11/22 – 2018/10/17）
* Apache HAWQ（2015/9/4 – 2018/8/15）
* Apache RocketMQ（2016/11/21 – 2017/9/20）
* Apache CarbonData（2016/6/3 – 2017/4/19）
* Apache Kylin（2014/11/25 – 2015/11/18）

Apache软件基金会孵化项目中中国项目有10个，在2021年有5个新项目进入到ASF项目孵化器，全部来自于中国。10个孵化项目分别是：

* Apache SeaTunnel (2021/12/09)
* Apache Linkis (2021/08/02)
* Apache Kyuubi (2021/06/21)
* Apache ShenYu (2021/05/03)
* Apache EventMesh (2021/02/18)
* Apache Pegasus（2020/06/22）
* Apache InLong（原 TubeMQ，2019/11/03）
* Apache Teaclave (原 MesaTEE, 2019/08/19）
* Apache brpc（2018/11/13）
* Apache Doris（2018/07/18）

ASF全球有800+members，目前已知并互动较为频繁的中国及华人members有29位；其中，姜宁在2022年3月ASF举行的成员会议上被选举成为新任董事。

Apache软件基金会现有中国企业赞助商6家，分别是白金赞助商：华为、腾讯云；黄金赞助商：百度；银牌赞助商：阿里云，滴滴出行；银牌赞助商：小米。

|白金赞助商|黄金赞助商|白银赞助商|银牌赞助商|
|:--------:|:--------:|:--------:|:--------:|
|华为|百度|阿里云|小米|
|腾讯云|  |滴滴出行|  |


在Apache软件基金会2021年财报中，数据统计来自中国的用户数量最多。

![在这里插入图片描述](https://img-blog.csdnimg.cn/068ba95958f7410489185e0b7fcd5531.png#pic_center)<br/>


### 9.2.2 中国成员在Linux基金会（LF）的参与度
 
Linux基金会董事会成员共23人，其中中国成员2人，占比为8.6%。分别为华为的侯培新与腾讯的刘鑫。

Linux基金会目前共有中国会员139家，相较于2020年的70家增涨了98.6%。其中白金会员2家（约占14.3%）；黄金会员3家（约占16.7%）；白银会员112家（约占9.5%）；Associate（准会员）22家（约占7.9%）。

|白金会员|黄金会员|
|:--------:|:--------:|
|华为|阿里云|
|腾讯|百度|
|  |微众银行|


### 9.2.3 中国成员在云原生计算基金会的参与度
 
据CNCF的统计，超过20%的开源项目来自中国，贡献度排名上升至世界第二。在云原生应用上，68%的机构在生产过程中使用容器，31%的开发者称所在单位的容器使用量已经超过5000个。CNCF理事会共29名成员，其中中国成员3人，分别是阿里巴巴的李毅、华为 Bryan Che和火山引擎（字节跳动）张鑫。

CNCF目前共有中国会员84家，其中包括有3个白金会员（占13.6%）、10个黄金会员（占40%）、67个白银会员（占11.1%）、1个Academic（占25%）、以及3个最终用户会员（占2.9%）。中国会员目前占CNCF总数的10.7%，较2021年统计增长了2.7%。

|白金会员|黄金会员|
|:--------:|:--------:|
|阿里云|蚂蚁金服|
|华为|百度|
|火山引擎|新华三|
|  |浪潮|
|  |软通动力|
|  |京东云|
|  |金山云|
|  |浦发银行|
|  |腾讯云|
|  |中兴|


### 9.2.4 中国成员在开源基础设施基金会（OIF）的参与度
 
OIF基金会董事会27人，其中中国成员11人（占40.7%）。分别为烽火通信陈刚；易捷行云李中华、林冠宇；中国移动焦鹏举；中国联通钟忻；英特尔练丽萍、王伟；九州云李开；腾讯任钟坪；蚂蚁金服王旭；华为任旭东。OIF现有中国成员中包括白金会员4家（占44%）；黄金会员9家（占53%）；白银会员1家（2.2%）；支持机构14家（占4%）。

|白金会员|黄金会员|
|:--------:|:--------:|
|蚂蚁集团|九州云|
|烽火通信|中国移动|
|华为|中国电信|
|腾讯云|中国联通|
|  |EasyStack（北京易捷思达科技有限公司）|
|  |浪潮|
|  |新华三|
|  |卓朗昆仑云|
|  |中兴通讯|


### 9.2.5 中国成员在开源发明网络社区（OIN）的参与度
 
目前OIN社区现有中国成员共125个，较2021年统计增长26%，部分成员表如下。

![在这里插入图片描述](https://img-blog.csdnimg.cn/92027a8976a44c9389052817f5a16106.png#pic_center)<br/>



## 9.3 中国头部科技企业的开源贡献

### 9.3.1  华为

**重点开源项目**

**OpenHarmony**，是由开放原子开源基金会（OpenAtom Foundation）孵化及运营的开源项目,目标是面向全场景、全连接、全智能时代。基于开源的方式，搭建一个智能终端设备操作系统的框架和平台，促进万物互联产业的繁荣发展。OpenHarmony最新版本为v3.1，发布于2021年12月30日。更新了23个领域关键特性，累计20块开发板，累计204个开发样例。截至目前，已成立38个SIG；代码贡献者1783人；贡献单位共计40家；已有25家机构完成捐赠，募集捐赠款1250万元。陈海波、中科院软件所武延军、51CTO张荣超、深开鸿张兆生、华为贾宁、上海交大臧斌宇、华为李英伟7人被选举为OpenHarmony TSC（Technical Steering Committee 技术指导委员会）成员；OpenHarmony PMC（Project Management Committee项目管理委员会）扩容至19人；工作委员会成员扩至8家；活动与营销工作组有38家单位成员，6大开发者社区专区建设（CSDN、51CTO、开源中国、思否、电子发烧友、InfoQ），104个高校阵地（有组织者的高校）。已有2000人进入“OpenHarmony 成长计划“并作为布道师进行培养。已将所有生态进展集结成册，形成《OpenHarmony 生态专刊》（144页），2021 年12月28日印刷并在南京OpenHarmony开发者见面会首次分发。

**昇思MindSpore**，通过社区合作，面向全场景构建最佳匹配、支持多处理器架构的开放AI架构，为算法工程师和数据科学家提供开发友好、运行高效、部署灵活的体验。目前，昇思MindSpore下载量已超130万，4000+社区贡献者，5000+企业应用上线。其中手机应用日均7亿+调用量，300+主流网络模型实现。在码云上，MindSpore社区共有21个仓库，总Star数达到1.6万+，总PR数超5.2万，主仓库Gitee指数为96分，领跑同类项目。
 
**OpenEuler**，是由开放原子开源基金会（OpenAtom Foundation）孵化及运营的开源项目。通过社区合作，打造创新平台，构建支持多处理器架构、统一和开放的操作系统openEuler。2021年9月25日OpenEuler全新发布，同时支持服务器、云计算、边缘计算、嵌入式等各种形态设备的需求。支持多样性计算，致力于提供安全、稳定、易用的操作系统；并通过为应用提供确定性保障能力，支持OT 领域应用及OT 与ICT 的融合。至此全新发布的欧拉操作系统可覆盖从IT、CT 到OT 数字基础设施全场景。作为国内最活跃的开源社区，已有300家以上头部企业加入，8000多名社区开发者，持续在社区贡献，90个以上SIG，8000多个代码仓，截止2021年12月31日，个人贡献者占比累计近40%，企业贡献占比累计超60%；其中万级以上PR贡献企业一名（华为技术），千级PR贡献企业两名（麒麟、统信）。OpenEuler下载使用用户超过37万。主流操作系统厂商，如，麒麟，统信，SUSE，麒麟信安，普华，中科创达等均已发布基于openEuler商业发行版，这些发行版已在及金融、运营商、电力、政府信息中心等重点行业核心系统达90万套以上规模落地。


## 9.3.2 阿里
 
**重点开源项目**

**RISC-V基金会**，平头哥和阿里云推动RISC-V International国际组织的技术标准建设，参与20个技术组的工作，并承担了其中7个技术组的Chair/Vice Chair职务；参与3个技术委员会工作，并担任其中1个委员会的Vice Chair一职，输出一项CSI技术平台标准，重点推动Linux、Vector、QEMU等技术对RISC-V的优化支持工作，其中在QEMU社区，合入主枝108个patch，代码11000行，解决了RISC-V中UXLEN动态变化，Vector扩展等难题，另有Packed, Fast Interrupt, RISU等100+ patch 在Review中。在kernel.org社区贡献2w+行代码、200多个patches，促进玄铁与Linux社区的合作，完善玄铁开源生态。
 
**Apache Flink**，以Apache Flink为例，阿里巴巴贡献了近三分之一的committer。
 
**Redis**，在Redis社区，阿里云累计向Redis社区贡献200多个patch，在参与贡献Redis社区的各个企业中排名第二。在目前最具重量级的版本Redis6.0中贡献超过80个patch，排名第二（仅次于Redislabs），并得到了原作者的点名致谢。阿里作为Redis社区的杰出贡献者，是社区核心团队core team的5名成员之一，向Redis社区贡献了Multi-part AOF、Geosearch、Lua replication refactoring等重量级feature，参与制定了Redis 6.2/7.0的Roadmap和发布计划。
 
**Kubernetes**，阿里云推动Kubernetes社区新一代调度架构scheduling framework的演进和落地，贡献了40+ patch；同时引导原生调度能力支持批量任务的发展，向社区贡献协同调度、容量调度、外置队列等核心能力，落地OpenAI、苹果、百度等公司，得到CNCF TOC委员的转发和点赞，一致认为认为这个工作满足了批量任务和科学计算领域的核心需求。

**TensorFlow&Pytorch**，在TensorFlow生态中，阿里作为TensorFlow Recommender SIG社区的主要Owner，对SIG中核心的功能EmbeddingVariable进行维护和优化，并参与制定 SIG的Roadmap和发布计划。另外，阿里还开源了业界最早完备支持动态shape编译的AI编译器BladeDISC。能够以TensorFlow/Pytorch插件的形式为AI用户E2E提供通用透明的性能优化，也是业内基于MLIR最早能够投入商用的E2E编译框架，此外能够帮助新硬件厂商提供AI框架的新硬件接入支持。
 
**OpenJDK**，阿里云累计向 OpenJDK 社区贡献120+个patch，覆盖OpenJDK 8u, 11u, 17u, 以及主干等多个核心版本。阿里云通过社区合作，和 Azul、Datadog、Redhat 等成功将 JFR 移植回 OpenJDK8u（主流Java版本之一）。阿里云作为RISC-VInternational(RVI)社区Managed Runtime SIG的主要Owner，制定和推动SIG的发展计划，推动OpenJDK社区full-featured RISC-V架构移植项目进入主树。阿里云是OpenJDK 社区活跃的长期活跃企业之一，也是国内唯一的Java标准执行委员会(JCP EC)成员。
 
**Eclipse**，阿里云累计向Eclipse社区贡献150+个patch，向Eclipse社区开源并主导了Eclipse Jifa项目。阿里云作为战略基石成员，加入Eclipse Adoptium工作组，致力于创建开放、厂商中立的JDK运行环境，支持Java生态发展。
 
**GraalVM**，阿里云在GraalVM项目中贡献了22个PR，累计修改代码5418行。阿里云作为GraalVM社区的重要的贡献者，向GraalVM 21.2.0， GraalVM 21.0.0版本贡献了提前注册动态加载类，JDK原生序列化等重要特性，阿里云是GraalVM项目咨询理事会唯一的国内企业代表。
 
**Clang/LLVM **，阿里云累计向 Clang/LLVM 社区贡献 170+ patch，在RISC-V、AArch64等重要架构编译器后端有系统化的代码贡献，是RISC-V架构编译器生态重要贡献者。在中端IPO、Function Specialization等优化上积极与社区、其他公司合作，共同提升LLVM优化能力。在语言侧，开发和维护 C++20 Coroutine ，完成大量优化、可调式性等工作，C++20 Coroutine成为Clang/LLVM完整支持的语言特性。目前仍在活跃开发、贡献C++ Modules 等重要特性。阿里云也成为第一家加入 C++ Committee 的国内企业。

### 9.3.3 百度（补充电线杆巡检AI成绩
	 
**重点开源项目**

**飞桨（Paddle）**，目前，飞桨已凝聚406万开发者，基于飞桨开源深度学习平台创建47.6万个模型，服务15.7万家企事业单位。飞桨助力开发者快速实现AI想法，创新AI应用，作为基础平台支撑越来越多行业实现产业智能化升级。2021年飞桨框架发布了v2.0版本，正式进入了2.0时代，随后又完成了2.1和2.2两个版本的迭代更新。截至2021年12月31日，整体飞桨Family star数累计109680（增长99%），开源社区累计提交Commits超过50万次，以PR或ISSUE提交形式的开源贡献者超过了15000人。飞桨开发者技术专家（PPDE）累计180多位，飞桨开源合作伙伴计划已汇聚33个全球知名开源项目、8个国际开源组织/社区/基金会。飞桨领航团是面向所有深度学习技术爱好者的兴趣社区，目前已在全球建立200+社群。
 
**阿波罗（Apollo）**,2021年Apollo发布了Apollo 6.0 EDU和Apollo 7.0两个版本，其中Apollo 7.0，开放代码70w+行，GitHub Stars 19k+。目前Apollo开发者社区已经拥有来自全球135个国家，80000多名开发者，涵盖339+所高校，547+家科技公司，107+家车企，53+家政企/研究所。Apollo项目在2021年获得两项大奖，分别是2021 世界人工智能大会《 SAIL AWARD TOP30》和2021 MathorCup高校数学建模挑战赛《优秀出题单位奖》。基于Apollo开放平台，Apollo开发者社区将不断开源共享，带动全球开发者持续创造，共建互惠互利的自动驾驶生态体系。
 
**百度超级链（XuperChain）**,百度主导发起的开源区块链项目，全球开发者数量超过50000+。目前XuperChain在Github star数1550+，2021年新增Commit数560+、主版本迭代3次，新增仓库数12个。在关键区块链生态技术工具上，新增由外部企业贡献XuperIDE、XuperScan（浏览器）等技术工具。2021年全年组织40+场线上直播和线下沙龙，覆盖30000+开发者，社区面对来自100多家企业和高校的爱好者进行社区官方讲师认证，完成两套课程内容并出版一部教材，与20+家双一流高校达成区块链人才培养合作计划。在2021年内，XuperChain先后通过中国信通院功能和性能测试。
 
**Apache ECharts** 是一个使用 JavaScript 实现的开源可视化库，可以流畅的运行在 PC 和移动设备上，兼容当前绝大部分浏览器，底层依赖矢量图形库 ZRender，提供直观，交互丰富，可高度个性化定制的数据可视化图表。作为Apache软件基金会的顶级项目，目前Apache Echarts在Github star数49k+，年增10%；Contributor185人年增26%，其中5人在2021年成为Committer，2021年内Apache ECharts共更新发布8个版本。
 
**Apache Doris** 是由百度开源并贡献给Apache软件基金会的MPP分析型数据库产品。Apache Doris 分布式架构非常简洁、易于运维，可以支持10PB以上的超大数据集。Apache Doris的GitHub Star从2021年初的2k增长到3.9k ，一年间增加了95%。贡献者数量从年初的130增至234 ，贡献者规模和活跃度都有了极大的提升。与此同时，在2021年Doris社区还迎来了5位新晋PPMC以及7位Committer加入，分别来自美团、小米、京东等多家一线互联网公司。Apache Doris分别在2021年4月和11月发布了0.14和0.15版本。


### 9.3.4 腾讯

#### 推动开源“三箭齐发”

**发力项目开源**。从开源第一个微信移动端项目开始到目前，腾讯已经开源了超过130个自主研发项目，覆盖云原生、大数据、人工智能、操作系统、移动开发等基础技术领域。在Github上，腾讯累计获得了超过38万开发者的关注和Star，是全球企业开源贡献榜中TOP8企业，有超过3000名国内外开发者参与到腾讯开源生态中。
 
**贡献社区治理**。腾讯持续贡献着30多个主流开源社区，并加入了Linux基金会、Apache 基金会等十余个国际开源基金会，是开放原子开源基金会最早的发起单位之一。近三年来，我们连续向Linux、Apache、开放原子开源、CNCF等多个基金会等捐赠了TARS、TSeer、Angel等7个开源项目，主导LinuxKVM、Jdk等9个国际开源项目。腾讯开源治理正从广撒网向高质量转变。2020年新冠疫情期间，腾讯第一时间参与到Linux基金会公共卫生计划LFPH中，成为中国唯一的创始成员单位，为全球合作抗击疫情贡献开源力量。
 
**聚焦生态共建**。将腾讯云两大底层技术——物联网操作系统TencentOS tiny和企业级容器编排引擎TKEStack捐赠给开放原子开源基金会，并同合作伙伴共同发起操作系统开源社区OpenCloudOS。ApacheInlong（应龙）、SuperEdge等多个项目陆续捐赠进入国际顶级基金会孵化和毕业。TARS项目更是进一步孵化，成立了Linux基金会旗下专注微服务领域的子基金TARS基金会，是第一家由中国公司发起成立的软件基金会，极大增强中国在该生态领域的发言权。

### 9.3.5 中兴通讯
 
**国内外主流开源基金会重要的参与者和贡献者**。中兴通讯是Linux基金会旗下的LFN和LF AI & Data的创始成员以及最高级别会员，拥有两大基金会的董事会、TAC等席位；也是Open Infrastructure基金会（原Open Stack基金会）重要的黄金成员，中兴通讯在该基金会贡献颇多。在Train版本中Commits总数达到5000以上，位居全球第六。Ussuri版本中LoC 45万行代码，位居全球第四；是国内最早参与Ceph社区的公司之一，在已发布的K～M三个版本中，贡献位居全球前三，中国第一；在LF AI & DATA基金会孵化推理侧工具链Adlik，经权威机构评测，公司主导的开源推理侧加速器项目Adlik处于全球领先水平。
 
**标准与开源大融合的践行**。中兴通讯是首批参加OPNFV、OpenDaylight开源社区的电信网络设备厂商。电信网络向虚拟化、容器化和智能化转型、标准与开源深度融合的践行者。2015年中兴通讯以铂金会员加入OPNFV社区，是首批通过OVP（OPNFV Verified Program）认证的厂商。2016年，中兴通讯支持中国运营商在Linux基金会发起的网络自动化管理项目ONAP前身Open-O立项，为Open-O贡献超过50%的代码。 2017年成为ONAP初创会员，并担任微服务总线MSB、告警分析Holmes两个子项目的PTL。2017年，中兴通讯以铂金会员加入OpenDaylight社区，将SDN协议的代码实现贡献到社区，共发起了6个新项目，并参与了社区80%的重要项目。2017年，中兴通讯以黄金会员加入CNCF， OpenPalette产品获CNCF社区Kubernetes一致性认证，获得社区KCSP认证。2018年，中兴通讯OPNFV 开放实验室通过OVP Lab认证。2019年，中兴通讯首批参与GSMA和OPNFV联合发起CNTT项目，与主流运营商和设备厂商共同制订电信网络基础设施的模型、架构和测试规范。2020年，中兴通讯支持中国运营商在Linux网络基金会发起的5G/6G电信能力平台xGVela的立项，并贡献Telco PaaS初稿。大力推动5G网络切片、网络管理自动化、网络智能化等开源与标准在5G中的结合与应用。
 
**与国内同行携手打造以国内厂商和用户为主体的开源新生态**。2021年，中兴通讯以创始单位加入智能计算产业技术创新联合体（ONIA），与行业伙伴共同推动开源神经网络处理器指令集架构NPU-IAS生态，成为ONIA的理事单位。中兴通讯继续在国际RISC-V基金会组织中发挥创始成员（现改为铂金会员）的作用，共同讨论处理器指令的开发，提出RISC-V在HPC领域的问题。在2021年，公司以高级会员身份加入了国内最大的RISC-V开源生态组织“北京开源芯片研究院”，与国内龙头企业（互联网、设备商、芯片设计方）、高校及研究所共同研究RISC-V开源生态建设和探讨后续工作规划。2021年底，中兴通讯GoldenDB产品线联合工行、招行、银联、网联、金电、华为、金融联盟共同发起MySQL金融分支开源社区，并进入MySQL金融分支的社区管理组（PMG）和技术管理组（TMG）。在中国开源产业联盟OSCAR 2021峰会上，Adlik凭借出色的技术创新性、贡献活跃度、应用成熟度等在层层遴选中脱颖而出，荣获 “开源项目及开源社区奖”。


### 9.3.6 中国联通
 
**参与开源社区**，目前参与的开源社区主要涉及云计算、白盒交换机、白盒基站、网络编排器等领域，包括OpenInfra/OpenStack基金会（担任黄金会员董事）、Linux基金会（白银会员）、OpenEuler社区等。在Linux基金会白银会员基础上，中国联通作为白银会员/高级会员参加了LFN、SODA（担任董事）、CNCF子基金会。
 
**积极贡献开源**，自研海量数据存储项目YIG和AI算能服务平台CubeAI智立方已分别被LF SODA和OpenI启智社区接受为原生项目和孵化项目。其中，YIG实现中国联通在国际主流开源社区牵头项目“零”的突破。
 
**国产开源建设**，着力发展国产化云生态，积极加入欧拉社区，并在OpenStack SIG 小组担任Maintainer。2021年11月，正式发布自主知识产权操作系统CULinux（China Unicom Linux），结合轻量级虚拟化、高性能网络、安全容器等技术，可广泛应用于服务器、边缘计算、云基础设施等多种场景，支持多样性算力，已适配X86和鲲鹏、飞腾等主流国产化算力底座，为算网融合提供关键技术保障，实现完善统一的底层技术体系。


### 9.3.7 小米
 
2021年，小米在23个开源项目中保持活跃。其中，自研项目6个，主导项目3个，参与项目14个。这些项目中，大部分推出了Committer，总的Committer人数达50人。公司全年共为各类开源社区贡献patch数超3000个。同时，不断有新的项目申请开源，其中3个新项目在2021年内通过了开源评审后对外开源。

开源人才贡献上，新增Apache Committer 11人，其他项目Committer 13人。在Hadoop、Hive、RocketMQ、Dubbo、TiDB等多个有影响力的开源项目上，小米首次推出Committer，实现自我突破。根据Apache软件基金会发布的2021年度报告，公司员工肖翔因为其在Apache NuttX项目上的突出贡献，荣登Top5 Committers名单。此外，小米开源在2021年积极参加开源生态建设。

* 5月，通过信通院“可信开源供应链”认证，成为国内首批通过可信开源供应链认证的终端厂商之一。
* 8月，Vela成功举办了国内首次NuttX开发组研讨会，多平台直播最高观看人数3000+，整个线上交流会讨论热烈，获得了很好的效果。
* 9月，机器人开源社区完成了开源风险评估，正式对外开源。不久，CyberDog项目通过信通院可信开源项目认证，成为信通院可信开源社区共同体的首批会员。
* 9月，举办Apache Pegasus 首次 Meetup。Meetup 共计时长5小时，线下参加的人数达75+，线上B站和Datafun直播观看人数达800+。
* 10月，小米升级为Apache基金会的Targeted Sliver Sponsor。

同时，小米积极倡导和布道开源文化，通过参加开源中国开源世界高峰论坛、云原生产业大会、CCF未来计算机教育峰会、OSCAR开源产业大会、开发者生态峰会、东北亚开源软件推进论坛等多个大会，传递独特的开源文化。小米积极将自身的开源实践经验输出到外部，《开源项目与社区案例集》第一期收录了小米MACE、Pegasus两个项目的开源实践案例，《企业开源治理案例集》第一期收集了小米公司的开源治理案例。公司全程参与筹备的中国计算机学会开源发展委员会在2021年12月正式成立。


### 9.3.8 滴滴
 
2021年,滴滴开源成为多家开源基金会、开源组织的首批会员，并积极在社区中发挥主导作用。

2021年3月，由中国开源软件推进联盟副秘书长北京大学荆琦教授牵头组织，滴滴和北大软微学院联合开设的“开源软件开发基础及实践”课程通过了北京大学研究生院的新课申请，正式面向北大软微学院全体研究生开放授课。   

2021年10月，滴滴开源作为发起成员单位之一参与筹备北京开源创新委员会，同时安旭入选委员会专家组。

2021年11月，滴滴开源参与Linux 基金会旗下 NextArch Foundation下一代架构基金会的筹建工作，成为首批共建和支持单位。同时齐楠作为企业代表成为TOC成员，参与探讨和制定基金会的发展路线工作。

2021年12月，滴滴开源成为CCF开源发展委员会首批企业成员，石东海、安旭成为首届执行委员。

2022年1月，Dokit、DELTA、LogicFlow、KnowStreaming等四个滴滴开源项目通过中国信通院评审，成为《可信开源社区》共同体成员。

2022年2月，Dokit和KnowStreaming入选中国科协“科创中国”的《开源创新榜》。

截至2021年末，滴滴开源共有超过81个对外开源项目，其中9个新增对外开源项目，它们来自6个事业部。滴滴外部开源总Star数8w+，Fork数2w+，Issue数4k+，5 k+公司及组织使用了滴滴开源项目，开源项目的开发者和用户超过2w人。滴滴内部开源项目新增118个，突破500大关，年度累计4k+人参与内源，累计产生161个社群，253个技术子项。

2021年滴滴开源还涌现出一位ASF孵化器导师、一位Apache基金会顶级项目Pulsar的committer。滴滴开源的消息与函数团队为Apache Pulsar 项目持续贡献了49个PR，其中33个完成合并；系统软件团队向Linux内核/OVS等社区贡献10个patch，参与多个patch的review并给出改进建议；KV团队向rocksdb社区贡献4个PR完成合并；DT-计算平台为HDFS，iceberg，ClickHouse，starrocks，pulsar，bookkeeper的等项目贡献56个paches。

* **DoKit，**目前在 GitHub上的star数已经突破18000，已累计有14000+终端App接入使用。
* **LogicFlow，**2021年在npm发布了90+小版本，并于2021年12月31日发布1.0版本。目前已有较多公司在实际项目中接入使用，LogicFlow平均npm周下载量40k+、 github star 2k、收到github issue 200+。
* **Know Streaming，**在滴滴内部满意度高达90%的同时，开源产品已被2000多名用户使用（涉及电商、教育、物流、视频、金融等不同领域用户），还与国内多家头部金融、电信、电力研究机构达成商业化合作。Know Streaming基于Apache-2.0协议进行分发和开源，为Kafka国产化提供了坚实技术保障，未来考虑捐赠给国内开源组织，为中间件类基础软件运维管控做一点自己的贡献。


### 9.3.9 微众银行

2021年2月，EventMesh项目成功通过投票成为国际顶级开源组织 Apache软件基金会（简称ASF）的孵化项目，这也是国内金融行业首个进入 ASF 孵化器的开源项目；8月，Linkis项目功进入ASF孵化器。

在AI领域，FATE作为微众银行人工智能团队发起的全球首个联邦学习工业级开源框架，吸引了腾讯、Vmware、银联、工行、中行、农行、建信金科、光大科技等10余家外部企业加入到开源TSC（技术指导委员会）中，形成TSC board和TSC maintainer的组织架构，共同参与项目的发展和社区的建设。截止到2021年底，社区用户数超过3500人，社区企业数超过1000家，高潜客户数400个以上。

在大数据领域，公司开源的WeDataSphere大数据开发平台已经成为业界较有影响力的开源社区。截止2021年7月，Linkis已拥有了700多家试验企业和超过1000个沙盒试验用户，涉及金融、电信、制造、互联网等多个行业。通过将项目捐献给Apache软件基金会，进一步加快社区治理体系的建设以及促进社区生态繁荣。


### 9.3.10 浪潮软件
 
浪潮先后加入OpenStack、Linux Foundation、Apache、SPEC、TPC等国际权威组织，以及全球三大开放计算标准组织，并成为ODCC供应商会员、OCP铂金会员和OPEN19首批成员。公司非常注重国内开源社区的建设，是木兰开源社区首批贡献者和社区建设的践行者，同时作为创始会员共同筹建了中国首个、也是目前唯一一个以开源为主题的基金会——OpenAtom开放原子开源基金会，并作为副理事长单位积极参与到社区建设中。
    
在社区即将发布的Yoga版本中，代码提交量（Commits）、完成蓝图数量（Completed Blueprints）、补丁集数量（Patch Sets）、贡献代码行数（LOC）等方面表现突出。

公司向OpenStack国际开源社区贡献首个智能运维领域开源项目VENUS并完成孵化，顺利成为官方项目；云海OS团队聚焦Nova、Cinder、Cyborg、Manila等核心项目，实现对异构加速器设备虚拟机的支持并完善虚拟机重建和疏散、搁置和取消搁置等功能；新增任意时间节点的卷快照回滚功能、Inspur SSD、FPGA设备驱动、文件存储回收站等特性，并在智能加速设备管理Cyborg、可视化日志管理Venus、云数融合Sahara和高可用管理Masakari等主流项目新增PTL（开源项目负责人）4名，Core Reviewer 十数名，社区全球贡献排名全球前五，国内第一。

**CNCF社区贡献情况**。自2017年开始，在声明式集群管理、多容器运行时、多容器网络、多容器存储、镜像加速、网络加速、主备容灾等方面重点技术研发，并持续回馈社区，累计提交贡献4000+。基于CNCF CKAD认证体系和Kubernetes项目的实践经验，已开展云原生系列课程培训20余次，旨在通过标准化的培训帮助开发者系统化学习云原生技术。通过CNCF Kubernetes X86和 ARM双一致性认证，为社区贡献首个MIPS架构Kubernetes一致性测试方案。

**OpenAtom社区贡献情况**。围绕低代码、工业互联网、云原生等技术领域，广泛参与Apere CAS Server、Helm、Bitnami、SEATA等开源项目贡献。推出了业内首个开源+标准模式的低代码开发建模体系UBML（Unified Business Modeling Language，统一业务建模语言），UBML目前已成为OpenAtom开源基金会的孵化项目。

**木兰社区贡献情况**。贡献云操作系统控制台OpenSkyline项目到木兰开源社区，通过TOC评审顺利进入木兰开源社区开源项目孵化池。基于Gitee、Github、Trusite多库托管，实现各平台项目代码相互备，成功发布第一个正式版本，推动国内开源社区建设。

### 9.3.11 京东
    
京东对外开源了前端、云计算、人工智能、区块链、联邦学习等一系列项目。2018年将分布式文件系统和对象存储系统ChubaoFS项目捐献给CNCF基金会，并于2020年进入沙箱。
    
除此之外，京东也紧密保持着与国内外开源基金会与组织的联动，京东不仅是CNCF会员、OpenEuler会员，还加入了中国信通院云计算标准和开源推进委员会、科技制造开源技术应用社区，并且也是开放原子基金会的初始会员之一。未来京东也将持续积极参与开源生态建设。


## 9.4 中国原生开源企业加速涌现
 
### 9.4.1 麒麟软件
 
麒麟软件积极参与开源社区贡献，是 Linux、Ubuntu、Debian、Ubuntu Kylin、UKUI、OpenStack、OpenEuler、Gnome、Unity、Ceph、Ovirt等知名开源组织和项目的重要贡献者与维护者。由麒麟软件发起的开源项目Ubuntu Kylin 开源桌面操作系统累计安装量（仅官网下载统计）超3800万、UKUI桌面环境进入多数主流Linux发行版软件仓库。

公司热衷于开源布道，为埃塞俄比亚、加纳、赞比亚等7个国家提供开源操作系统培训服务，并累计在全球30多个城市的50多所大学里举行了版本发布会、麒麟杯软件大赛、开发者大会、Linux应用沙龙、生态软件测试、KMRE体验等超过100场的线下活动，让开源操作系统真正走进了多所高校的教学课堂和课程实践，培养出 Linux人才数万人。

#### 重点开源项目
 
**UKUI**，是一款基于Linux系统可插入框架的轻量级桌面环境。基于 Qt进行开发，为浏览、搜索和管理计算机提供了更简单，更愉快的体验。截止2022年2月，UKUI项目Issue超过4600，Pull Request超过3000，Commit超过17100，Contributor共246人。
 
**优麒麟**，是一款通用桌面电脑操作系统，自2013年以来已发行19个正式版本，全球累计安装量超3800万次，社区爱好者数十万，社区贡献者数百位。截止2022年2月，Ubuntu Kylin项目Issue超过780，Pull Request超过650，Commit超过5290，现有5个SIG。
 
**Kernel.org社区**，麒麟软件向Linux Kernel同样做出了大量的贡献，覆盖范围包括 ceph、xor、raid、io_uring、net 等，在全球参与内核贡献的近900家企业中，贡献排名居244位，在国内贡献企业中排名第12位，累计Summit（Patch）104个。
 
**OpenStack社区**，截至2022年2月，麒麟软件向OpenStack社区累计Summit（Patch）5500+，累计修复Bug1600+，累计完成蓝图40+，累计贡献代码10W行。
 
**OpenEuler社区**，麒麟软件是openEuler社区核心参与者之一，2021年成为除华为之外openEuler社区的第二大贡献者。共有155人直接参与openEuler社区，其中2人为TC，24人为Maintainer。截至2022年2月，累计提交Issue 1300+，Pull Request 2000+，累计维护项目300+，累计参与代码类项目50+，发起6个SIG，在5个SIG中担任Maintainer。

### 9.4.2 统信软件
 
统信软件基于Linux内核自主研发并开源了DDE桌面环境以及系列应用软件，已被主流Linux发行版所采纳。在国际主流社区（Ubuntu、Debian、CentOS等）贡献组件数量超过70多个。积极参与上游Linux Foundation内核社区开源贡献，在操作系统核心组件如kernel、gcc、binutils、glibc、cmake、elfutils、libtool、clang、boost、gdb等领域，统信软件适配集成补丁超过5千个，自研开发并反馈上游社区补丁超过500个，其中被上游社区采纳数量超过400个。

同时，统信操作系统积极融合openEuler、openAnolis社区中iSulad、A-tune、stratovirt、secGear、babassl等多项国内优秀自研技术，形成更加符合未来技术发展方向的优秀通用操作系统。经历十余年的发展，统信操作系统社区版deepin，作为全球Linux最重要的发行版之一，全球累计下载量超8000万次，全球社区用户超过200万，在国际Linux发行版排名中长期位列前茅。

deepin开源社区累计发布了超过40个版本，持续更新近200次，支持33种语言，原创应用44款，贡献开源代码超过600万行，遍布6大洲33个国家共计一百多个镜像站点。在国外权威的全球操作系统活跃度分析网站Distrowatch上，deepin是排名最高的来自中国的社区发行版，自研的桌面环境DDE广受国内外用户喜爱，已被移植到包括Archlinux、OpenSUSE、Ubuntu、LinuxMint、Fedora、Manjaro等主流Linux发行版中。在国际主流社区（Ubuntu、Debian、CentOS等）贡献组件数量超过70多个。自加入了Qt社区，2020年代码贡献排名第五；截止目前2021年代码贡献度排名第三。

**社区贡献**
 
**统信开源社区（deepin）**，累计发布版本40余次，支持语言34种，累计下载量超过8000万次，全球社区用户超过200万，提供开源代码超过600万行，是国内屈指可数的国际社区。拥有6个海外社区，在40多个国家拥有130多个镜像站点，可为中国操作系统提供国际开源社区支撑。
 
**OpenEuler（欧拉）**：统信软件服务器研发负责人担任openEuler社区TC委员，6个sig组maintainer由统信软件研发专家担任，累计申报TC议题9次，提交issues 100+，提交PR 239个，参与社区sig例会113次，积极活跃于社区29个sig组（例如：kernel、虚拟化、容器、release、QA等重要sig）。已为社区提交Pull Requests 900+，Issues 900+，举办SIG Meeting 100+。贡献自主研发的桌面项目58个，在openEuler 21.09创新版本完成DDE大版本迭代一次并引入了自研的桌面影音软件。
 
**OpenAnolis（龙蜥）**：截至2021年7月底，完成社区代码仓库同步3600+，koji提交3900+，commit提交220+，bug提交30+，bug修复70+，以及部分社区技术文档编写；参与维护的社区sig组包括Cloud Kernel、DDE、跟踪诊断技术、高性能存储、全栈国密、Java语言与虚拟机、LoongArch、Distro、基础设施、QA；并轮值参与社区社群内开源用户问题反馈沟通与技术交流。
 
**上游贡献（Ubuntu、Debian、CentOS等）**：开源DDE桌面环境以及系列应用软件，已被主流Linux发行版所采纳。在国际主流社区（Ubuntu、Debian、CentOS等）贡献组件数量超过70多个。在核心组件如kernel、gcc、binutils、glibc、cmake、elfutils、libtool、clang、boost、gdb等领域，统信操作系统适配集成补丁超过5千个，自研开发并反馈上游社区补丁超过50个。


### 9.4.3 平凯星辰
 
TiKV是CNCF首个基于Rust的 KV Database项目，也是第12个从CNCF毕业的项目。Chaos Mesh是一个云原生混沌工程平台，目前还在CNCF的沙箱中孵化。PingCAP在帮助企业释放增长空间的同时，也提供了具有高度可参考性的开源建设实践样本。TiDB及其生态项目累计超过1700位开源贡献者，覆盖41个国家和地区，是全球基础架构领域的顶级开源项目。

与此同时，TiDB汇聚了15000+ TiDB资深用户，所有成员都可以在这里自由发声，互相协助解决问题。社区线上论坛asktug.com已经积累了13900+个问题帖，95% 的问题都得到了解决，累计总回复数 89800+。
 
**用户组**。TUG（TiDB User Group） 汇聚了全球数据库、大数据技术从业者，是一个独立、自治、不以盈利为目的的社区组织。组织使命：连接用户，共建未来数据生态。TUG 成员近 20% 为技术决策者，覆盖了互联网、金融、银行、电信、物流等行业，成立了北京、上海、杭州、华南（深圳 & 广州）、西南（成都 & 重庆）和 APAC（新加坡）6 个本地小组，沉淀了500+篇优质技术文章及精彩演讲。
 
**贡献者**。目前TiDB项目在GitHub上已总计获得超过30.6k颗星，累计超过1200位开源贡献者，目前项目已经合并的Pull request数21349个，已经解决的 Issue数8551 个。TiDB项目来自PingCAP以外的社区贡献者（Contributor）占比70%以上。

目前TiKV项目在GitHub上已总计获得超过10.8k颗星，累计超过470+位开源贡献者，项目已经合并的Pull request数8485个，已经解决的Issue 数2556个。TiKV项目主要开发者来自PingCAP、知乎、京东云、一点资讯等企业，来自PingCAP以外的社区贡献者（Contributor）占比65%以上。

目前Chaos Mesh在GitHub上已总计获得超过4.6k颗星，累计超过150+位开源贡献者，项目已经合并的Pull request数1847个，已经解决的Issue 数837个。

**开源社区活动**
 
**Infra Meetup**：自2016年3月5日开始，TiDB社区定期在周末举办Infra Meetup，邀请业内大牛与大家深度探讨基础架构领域的前瞻性技术思考与经验，目前已在北京、上海、广州、成都、杭州、深圳、西安等地成功举办 145 期活动。在这里，我们希望提供一个高水准的前沿技术讨论空间，让大家真正感受到自由的开源精神魅力。
 
**Paper reading**：是TiDB社区的小伙伴分享研读数据库、分布式等相关领域的论文心得的活动。希望通过对业界学术论文的分享，带大家了解数据库学术界最新的研究方向。
 
**TUG 企业行**：TUG企业行系列活动定期走入互联网顶级头部企业。一方面，听众有机会近距离接触企业，感受企业的文化和氛围；另一方面，企业可以就近聆听干货分享，也可以展示自身的技术实力。
 
**TiDB Hackathon**：参赛队伍需在规定时间（48小时）内围绕整个TiDB生态做出一个完整的作品，并由评审最终评选出获奖者。目前已成功在北京、上海、广州举办，超过 50 支队伍参与比赛。
 
**PingCAP DevCon**：“PingCAP DevCon”是由PingCAP举办的年度顶级数据技术盛会，大会已连续举办三年，成为观测开源产业、数据库前瞻趋势的风向标。
 
**TechDay**：TiDB TechDay是以城市为主体的技术分享活动，社区开发者共同学习、分享TiDB 技术内核，目前已成功在北京、上海、深圳、成都、武汉、杭州举办，覆盖人数 2000+。

#### 开源社区建设
 
围绕TiDB的生态也在不断发展，有大量的上下游生态项目在社区中涌现。PingCAP为这些项目提供了孵化器机制，帮助他们从社区中获取更多资源和帮助，能够快速成长达到有实际应用场景的成熟阶段。目前已经有优秀开源生态项目在孵化中.
 
**TiBigData**：由知乎发起的incubator项目TiBigData，旨在解决企业大数据场景中各项技术栈对接TiDB的整合问题。目前已提供TiDB与Flink和 Presto的整合能力，并已应用在知乎的数据集成平台和OLAP分析场景中。
 
**Weir**：Weir是伴鱼发起的面向分布式数据库的数据库中间件平台，现已完成 MySQL 协议支持、多租户管理、连接池、后端负载均衡、配置热加载、平台化管理等功能，在伴鱼内部开始推进业务接入。
 
**TiDB for PostgreSQL**：项目由神州数码发起，旨在提供TiDB对 PostgreSQL的兼容性，同时保留了TiDB的高可用性、弹性和可扩展性。允许用户将现有的PostgreSQL客户端连接到TiDB，并使用PostgreSQL 特有的语法。
 
**ServerlessDB for HTAP**：项目最终目标是要把云数据库服务变成黑盒子，让应用开发者只需要专注于业务如何转化成 SQL，用户再也不用操心数据量、业务负载、SQL 类型是 AP 还是 TP 等这些和业务不相关的事情。
 
**zh.md**:zh.md实现了一套中文文档分析与检测工具，基于 AST（抽象语法树）和分词，系统地对文档进行扫描与诊断，评估文档质量并对其进行优化和修复，并且基于文档分析结果，使用统计学/NLP 等工具，辅助作者写出符合风格规范的文档。

### 9.4.4 涛思数据
 
涛思数据采用AGPL许可证，已将TDengine 的内核(存储、计算引擎和集群）全部在GitHub 开源。2021年，TDengine仍然按照两周一个版本的频率迭代，同时改变了发布规则，同步推进beta版本和稳定版本，让社区用户可以更早体验到新功能。合并了4607个Pull Requests，正在运行的测试例接近1800个，软件代码行数共计104万行。

2021年，TDengine共发布了大大小小30余个新功能，重点包括：降低企业迁移成本的独立程序taosAdapter；基于Grafana的TDengine零依赖监控解决方案TDinsight；以及纳秒时间精度、浮点数有损压缩、原生接口写入、嵌套查询、无模式（Schemaless）写入等等。截至2022年2月底，TDengine 已经在 GitHub 上获得 17.8k Star，还多次在GitHub全球趋势排行榜上排名第一。

### 9.4.5 白鲸开源

目前，白鲸开源稳定运营着两个开源项目，分别为大数据工作流调度平台 Apache DolphinScheduler和大数据集成平台SeaTunnel。其中，基于Apache开源社区理念打造的Apache Dolphin Scheduler是全球知名的DataOps领域开源项目。

截至目前，已累计在600多家公司生产环境中作为企业的核心调度系统，包括IBM、腾讯、科大讯飞、美团、360、联通、顺丰等，覆盖金融、电信、零售、云计算、数据处理等广泛领域。贡献者超过310人，以开源社区的模式集合全球顶尖高科技公司的共同贡献。

### 9.4.6 思斐软件

ShardingSphere,是一套开源的分布式数据库中间件解决方案组成的生态圈，可以将任何的数据库转换为分布式数据库，并通过分片，弹性扩展，加密等功能对其进行增强。截止目，ShardingSphere项目被全球近200家企业登记使用，在GitHub上获得Stars超过15.4k，合并Issue超过6000，Pull Request超过9200 ，Contributor 超过300，累计贡献代码超过42万行。

SphereEx热衷于开源布道，在Google Summer of Code、西雅图创业协会、Stack Overflow等多个组织分享开源技术与创业经验。并累计在全球参与包括 PGConf.Asia、COSCon、ApacheCon、OpenSource Day、Grace Hopper Celebration、Hacktoberfest、FOSDEM、 Subsurface Live、 FOSS Backstage、DevConf等在内的50多次海内外线上、线下活动，推进开源数据库中间件走向更大的平台，为更多的开源爱好者提供学习支持。

ShardingSphere于2018年正式进入Apache基金会孵化器，2019年进入CNCF全景图，于2020年成为Apache顶级项目。2021年度Apache基金会年度报告中 ShardingSphere代码提交数量位列前十。





